
#include "nokia_5110.h"
#include "english_6x8_pixel.h"
#include "write_chinese_string_pixel.h"

/*-----------------------------------------------------------------------
LCD_init          : 5110LCDʼ
-----------------------------------------------------------------------*/

void delay_1us(void)                 //1usʱ
{
   unsigned int i;
  for(i=0;i<100;i++);
   
}

  void delay_1ms(void)                 //1msʱ
  {
   unsigned int i;
   for (i=0;i<1140;i++);
  }
  
void delay_nms(unsigned int n)       //N msʱ
  {
   unsigned int i=0;
   for (i=0;i<n;i++)
   delay_1ms();
  }

void LCD_init(void)
  {
  // һLCDλĵ͵ƽ
  // LCD_RST = 0;
	
    LCD_5110_DIR |= (0x01 << LCD_RST) + (0x01 << LCD_CE) + (0x01 << LCD_DC) 
	  				+ (0x01 << LCD_DIN) + (0x01<< LCD_CLK);
	
   LCD_5110_OUT &= ~(0x01 << LCD_RST);
    delay_1us();

  // LCD_RST = 1;
   LCD_5110_OUT |= (0x01 << LCD_RST);
    
		// رLCD
   //LCD_CE = 0;
    LCD_5110_OUT &= ~(0x01 << LCD_CE);
    delay_1us();
		// ʹLCD
   //LCD_CE = 1;
   LCD_5110_OUT |= (0x01 << LCD_CE);
    delay_1us();

    LCD_write_byte(0x21, 0);	// ʹչLCDģʽ
    LCD_write_byte(0xc8, 0);	// ƫõѹ
    LCD_write_byte(0x06, 0);	// ¶У
    LCD_write_byte(0x13, 0);	// 1:48
    LCD_write_byte(0x20, 0);	// ʹû
    LCD_clear();	        // 
    LCD_write_byte(0x0c, 0);	// 趨ʾģʽʾ
        
    // رLCD
    LCD_5110_OUT &= ~(0x01 << LCD_CE);
  }

/*-----------------------------------------------------------------------
LCD_clear         : LCD
-----------------------------------------------------------------------*/
void LCD_clear(void)
  {
    unsigned int i;

    LCD_write_byte(0x0c, 0);			
    LCD_write_byte(0x80, 0);			

    for (i=0; i<504; i++)
      LCD_write_byte(0, 1);			
  }

/*-----------------------------------------------------------------------
LCD_set_XY        : LCD꺯

X       083
          Y       05
-----------------------------------------------------------------------*/
void LCD_set_XY(unsigned char X, unsigned char Y)
  {
    LCD_write_byte(0x40 | Y, 0);		// column
    LCD_write_byte(0x80 | X, 0);          	// row
  }

/*-----------------------------------------------------------------------
LCD_write_char    : ʾӢַ

c       ʾַ
-----------------------------------------------------------------------*/
void LCD_write_char(unsigned char c)
  {
    unsigned char line;

    c -= 32;

    for (line=0; line<6; line++)
      LCD_write_byte(font6x8[c][line], 1);
  }

/*-----------------------------------------------------------------------
LCD_write_english_String  : Ӣַʾ

*s      Ӣַָ룻
          XY    : ʾַλ,x 0-83 ,y 0-5
-----------------------------------------------------------------------*/
void LCD_write_english_string(unsigned char X,unsigned char Y,char *s)
  {
    LCD_set_XY(X,Y);
    while (*s) 
      {
	 LCD_write_char(*s);
	 s++;
      }
  }
/*-----------------------------------------------------------------------
LCD_write_chinese_string: LCDʾ

XY    ʾֵʼXYꣻ
          ch_with ֵĿ
          num     ʾֵĸ  
          line    ֵеʼ
          row     ʾм
ԣ
	LCD_write_chi(0,0,12,7,0,0);
	LCD_write_chi(0,2,12,7,0,0);
	LCD_write_chi(0,4,12,7,0,0);	
-----------------------------------------------------------------------*/                        
void LCD_write_chinese_string(unsigned char X, unsigned char Y, 
                   unsigned char ch_with,unsigned char num,
                   unsigned char line,unsigned char row)
  {
    unsigned char i,n;
    
    LCD_set_XY(X,Y);                             //óʼλ
    
    for (i=0;i<num;)
      {
      	for (n=0; n<ch_with*2; n++)              //дһ
      	  { 
      	    if (n==ch_with)                      //дֵ°벿
      	      {
      	        if (i==0) LCD_set_XY(X,Y+1);
      	        else
      	           LCD_set_XY((X+(ch_with+row)*i),Y+1);
              }
      	    LCD_write_byte(write_chinese[line+i][n],1);
      	  }
      	i++;
      	LCD_set_XY((X+(ch_with+row)*i),Y);
      }
  }
/*-----------------------------------------------------------------------
LCD_write_byte    : ʹSPIӿдݵLCD

data    дݣ
          command д/ѡ

-----------------------------------------------------------------------*/
void LCD_write_byte(unsigned char dat, unsigned char command)
  {
    unsigned char i;
	LCD_5110_OUT &= ~(0x01 << LCD_CE);	// msp430
    
    if (command == 0)
     // PORTB &= ~LCD_DC ;	        // 
	//     LCD_DC = 0;
	  LCD_5110_OUT &= ~(0x01 << LCD_DC);
    else
     // PORTB |= LCD_DC ;		        // 
    // LCD_DC = 1;
	 LCD_5110_OUT |= (0x01 << LCD_DC);
		for(i=0;i<8;i++)
		{
			if(dat&0x80)
				//SDIN = 1;
			   LCD_5110_OUT |= (0x01 << LCD_DIN);
			else
				//SDIN = 0;
			   LCD_5110_OUT &= ~(0x01 << LCD_DIN);
			//SCLK = 0;
			LCD_5110_OUT &= ~(0x01 << LCD_CLK);
			dat = dat << 1;
			//SCLK = 1;
			LCD_5110_OUT |= (0x01 << LCD_CLK);
		}
   // SPDR = data;			// ݵSPIĴ

    //while ((SPSR & 0x80) == 0);         // ȴݴ
	
    //PORTB |= LCD_CE ;			// رLCD
    // LCD_CE = 1;
	 LCD_5110_OUT |= (0x01 << LCD_CE);
  }
